package ru.yandex.search.mop.server.config.database;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractDatabaseConfigBuilder
    <T extends AbstractDatabaseConfigBuilder<T>>
    implements DatabaseConfig
{
    private String driver;
    private String url;
    private String user;
    private String password;
    private int minIdleConnections;
    private int maxIdleConnections;
    private int maxOpenPreparedStatements;

    protected AbstractDatabaseConfigBuilder(final DatabaseConfig config) {
        driver = config.driver();
        url = config.url();
        user = config.user();
        password = config.password();
        minIdleConnections = config.minIdleConnections();
        maxIdleConnections = config.maxIdleConnections();
        maxOpenPreparedStatements = config.maxOpenPreparedStatements();
    }

    protected AbstractDatabaseConfigBuilder(
        final IniConfig config,
        final DatabaseConfig defaults)
        throws ConfigException
    {
        driver = config.getString("driver", defaults.driver());
        url = config.getString("url", defaults.url());
        user = config.getString("user", defaults.user());
        password = config.getString("password", defaults.password());
        minIdleConnections = config.getInt(
            "min-idle-connections",
            defaults.minIdleConnections());
        maxIdleConnections = config.getInt(
            "max-idle-connections",
            defaults.maxIdleConnections());
        maxOpenPreparedStatements = config.getInt(
            "max-open-prepared-statements",
            defaults.maxOpenPreparedStatements());
    }

    @Override
    public String driver() {
        return driver;
    }

    public T driver(final String driver) {
        this.driver = driver;
        return self();
    }

    @Override
    public String url() {
        return url;
    }

    public T url(final String url) {
        this.url = url;
        return self();
    }

    @Override
    public String user() {
        return user;
    }

    public T user(final String user) {
        this.user = user;
        return self();
    }

    @Override
    public String password() {
        return password;
    }

    public T password(final String password) {
        this.password = password;
        return self();
    }

    @Override
    public int minIdleConnections() {
        return minIdleConnections;
    }

    public T minIdleConnections(final int minIdleConnections) {
        this.minIdleConnections = minIdleConnections;
        return self();
    }

    @Override
    public int maxIdleConnections() {
        return maxIdleConnections;
    }

    public T maxIdleConnections(final int maxIdleConnections) {
        this.maxIdleConnections = maxIdleConnections;
        return self();
    }

    @Override
    public int maxOpenPreparedStatements() {
        return maxOpenPreparedStatements;
    }

    public T maxOpenPreparedStatements(final int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
        return self();
    }

    public abstract T self();
}
