package ru.yandex.search.mop.server.config.database;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class DatabaseConfigBuilder
    extends AbstractDatabaseConfigBuilder<DatabaseConfigBuilder>
{
    public DatabaseConfigBuilder() {
        this(DatabaseConfigDefaults.INSTANCE);
    }

    public DatabaseConfigBuilder(final DatabaseConfig config) {
        super(config);
    }

    public DatabaseConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, DatabaseConfigDefaults.INSTANCE);
    }

    public DatabaseConfigBuilder(
        final IniConfig config,
        final DatabaseConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public DatabaseConfigBuilder self() {
        return this;
    }

    public ImmutableDatabaseConfig build() throws ConfigException {
        return new ImmutableDatabaseConfig(this);
    }
}
