package ru.yandex.search.mop.server.config.database;

import ru.yandex.parser.config.ConfigException;

public class ImmutableDatabaseConfig implements DatabaseConfig {
    private final String driver;
    private final String url;
    private final String user;
    private final String password;
    private final int minIdleConnections;
    private final int maxIdleConnections;
    private final int maxOpenPreparedStatements;

    public ImmutableDatabaseConfig(final DatabaseConfig config)
        throws ConfigException
    {
        this.driver = config.driver();
        this.url = config.url();
        this.user = config.user();
        this.password = config.password();
        this.minIdleConnections = config.minIdleConnections();
        this.maxIdleConnections = config.maxIdleConnections();
        this.maxOpenPreparedStatements = config.maxOpenPreparedStatements();
        if (driver == null) {
            throw new ConfigException("Database driver is not set");
        }
        if (url == null) {
            throw new ConfigException("Database url is not set");
        }
        if (user == null) {
            throw new ConfigException("Database user is not set");
        }
        if (password == null) {
            throw new ConfigException("Database password is not set");
        }
    }

    @Override
    public String driver() {
        return driver;
    }

    @Override
    public String url() {
        return url;
    }

    @Override
    public String user() {
        return user;
    }

    @Override
    public String password() {
        return password;
    }

    @Override
    public int minIdleConnections() {
        return minIdleConnections;
    }

    @Override
    public int maxIdleConnections() {
        return maxIdleConnections;
    }

    @Override
    public int maxOpenPreparedStatements() {
        return maxOpenPreparedStatements;
    }
}
