package ru.yandex.search.mop.server.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.search.mop.common.searchmap.Queue;
import ru.yandex.search.mop.common.searchmap.QueueHost;
import ru.yandex.search.mop.server.pool.ConnectionPool;

public class QueueDAO {
    public static final String SELECT_ALL =
        "SELECT * FROM queue";

    private final ConnectionPool connectionPool;

    public QueueDAO(final ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public static List<Queue> parse(final ResultSet resultSet)
        throws SQLException
    {
        int maxId = -1;
        Map<Integer, List<QueueHost>> queuesMap = new HashMap<>();
        while (resultSet.next()) {
            int id = resultSet.getInt("id");
            String hostname = resultSet.getString("hostname");
            int httpPort = resultSet.getInt("http_port");
            int zkPort = resultSet.getInt("zk_port");
            queuesMap.computeIfAbsent(id, group -> new ArrayList<>())
                .add(new QueueHost(hostname, zkPort, httpPort));
            if (maxId < id) {
                maxId = id;
            }
        }
        Queue[] queues = new Queue[maxId + 1];
        for (Map.Entry<Integer, List<QueueHost>> entry: queuesMap.entrySet()) {
            queues[entry.getKey()] = new Queue(entry.getKey(), entry.getValue());
        }
        return Arrays.asList(queues);
    }
}
