package ru.yandex.search.mop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import ru.yandex.search.mop.common.searchmap.HostGroup;
import ru.yandex.search.mop.common.searchmap.Metashard;
import ru.yandex.search.mop.common.searchmap.Queue;
import ru.yandex.search.mop.common.searchmap.SearchMap;
import ru.yandex.search.mop.server.pool.ConnectionPool;

public class SearchMapDAO {
    private final ConnectionPool connectionPool;

    public SearchMapDAO(final ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public SearchMap getSearchMap() throws SQLException {
        try (Connection connection = connectionPool.getConnection()) {
            try (PreparedStatement versionStatement =
                     connection.prepareStatement(MetashardDAO.SELECT_MAX_VERSION);
                PreparedStatement queueStatement =
                    connection.prepareStatement(QueueDAO.SELECT_ALL);
                PreparedStatement metashardStatement =
                    connection.prepareStatement(MetashardDAO.SELECT_ALL);
                PreparedStatement hostGroupStatement =
                    connection.prepareStatement(HostGroupDAO.SELECT_ALL))
            {
                connection.setAutoCommit(false);

                ResultSet versionResultSet = versionStatement.executeQuery();
                ResultSet queueResultSet = queueStatement.executeQuery();
                ResultSet hostGroupResultSet = hostGroupStatement.executeQuery();
                ResultSet metashardResultSet = metashardStatement.executeQuery();
                int version = MetashardDAO.parseVersion(versionResultSet);
                List<Queue> queues = QueueDAO.parse(queueResultSet);
                List<HostGroup> hostGroups =
                    HostGroupDAO.parse(hostGroupResultSet);
                List<Metashard> metashards =
                    MetashardDAO.parse(metashardResultSet);
                connection.commit();
                return new SearchMap(version, queues, hostGroups, metashards);
            } catch (SQLException e) {
                connection.rollback();
                throw e;
            } finally {
                if (connection != null) {
                    connection.setAutoCommit(true);
                }
            }
        }
    }

}
