package ru.yandex.search.mop.server.pool;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.dbcp2.BasicDataSource;

import ru.yandex.search.mop.server.config.database.DatabaseConfig;

public class ConnectionPool {
    private final BasicDataSource dataSource;

    public ConnectionPool(final DatabaseConfig config) {
        dataSource = new BasicDataSource();
        dataSource.setUrl(config.url());
        dataSource.setUsername(config.user());
        dataSource.setPassword(config.password());
        dataSource.setMinIdle(config.minIdleConnections());
        dataSource.setMaxIdle(config.maxIdleConnections());
        dataSource.setMaxOpenPreparedStatements(
            config.maxOpenPreparedStatements());
    }

    public Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }
}
