package ru.yandex.search.mop.server.searchmap;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.mop.common.parsers.SearchMapJsonParser;
import ru.yandex.search.mop.common.searchmap.SearchMap;
import ru.yandex.search.mop.server.MopServer;

public class ServerSearchMapContainer {
    private volatile ServerSearchMap searchMap;

    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = lock.readLock();
    private final Lock writeLock = lock.writeLock();

    public ServerSearchMapContainer(final MopServer mop)
        throws SQLException
    {
        SearchMap searchMap = mop.searchMapDAO().getSearchMap();
        mop.logger().info("Searchmap upload from db: "
            + "version=" + searchMap.version() + ", "
            + "metashards=" + searchMap.metashards().size() + ", "
            + "queues=" + searchMap.queues().size() + ", "
            + "hostGroups=" + searchMap.hostGroups().size());
        this.searchMap = new ServerSearchMap(searchMap, readLock);
    }

    public ServerSearchMapContainer(final String file)
        throws JsonException, IOException
    {
        SearchMap searchMap = uploadFromFile(file);
        searchMap(searchMap);
    }

    public ServerSearchMap searchMap() {
        readLock.lock();
        try {
            return searchMap;
        } finally {
            readLock.unlock();
        }
    }

    public void searchMap(final SearchMap searchMap) {
        writeLock.lock();
        try {
            this.searchMap = new ServerSearchMap(searchMap, readLock);
        } finally {
            writeLock.unlock();
        }
    }

    public Lock writeLock() {
        return writeLock;
    }

    private SearchMap uploadFromFile(final String file)
        throws JsonException, IOException
    {
        try (Reader reader = new InputStreamReader(
            new FileInputStream(file),
            StandardCharsets.UTF_8))
        {
            return SearchMapJsonParser.INSTANCE.parse(reader);
        }
    }
}
