package ru.yandex.personal.mail.search.metrics.scraper.config.properties;

import javax.validation.constraints.Min;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix = "scraper")
@PropertySource(value = "classpath:properties/context.properties")
@Validated
public class AppProperties {
    @Min(0)
    private Integer retryBackOffSeconds;

    @Min(0)
    private Integer retryAttempts;

    private String persistentStoragePath;

    @NestedConfigurationProperty
    private AccountsProperties accounts;

    @NestedConfigurationProperty
    private CrawlerProperties crawler;

    @NestedConfigurationProperty
    private ArchiveProperties archive;

    public String getPersistentStoragePath() {
        return persistentStoragePath;
    }

    public void setPersistentStoragePath(String persistentStoragePath) {
        this.persistentStoragePath = persistentStoragePath;
    }

    public AccountsProperties getAccounts() {
        return accounts;
    }

    public void setAccounts(AccountsProperties accounts) {
        this.accounts = accounts;
    }

    public CrawlerProperties getCrawler() {
        return crawler;
    }

    public void setCrawler(CrawlerProperties crawler) {
        this.crawler = crawler;
    }

    public ArchiveProperties getArchive() {
        return archive;
    }

    public void setArchive(ArchiveProperties archive) {
        this.archive = archive;
    }

    public Integer getRetryBackOffSeconds() {
        return retryBackOffSeconds;
    }

    public void setRetryBackOffSeconds(Integer retryBackOffSeconds) {
        this.retryBackOffSeconds = retryBackOffSeconds;
    }

    public Integer getRetryAttempts() {
        return retryAttempts;
    }

    public void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }
}
