package ru.yandex.personal.mail.search.metrics.scraper.controllers;

import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.controllers.mapping.AccountMapping;
import ru.yandex.personal.mail.search.metrics.scraper.services.account.AccountManager;
import ru.yandex.personal.mail.search.metrics.scraper.services.account.AccountProperties;

@Service("accountController")
@Produces(MediaType.APPLICATION_JSON)
public class AccountController implements AccountMapping {
    private final AccountManager accountManager;

    @Autowired
    public AccountController(AccountManager accountManager) {
        this.accountManager = accountManager;
    }

    @Override
    public void addAccount(String system, String accountName, AccountProperties properties) {
        accountManager.initiateCreation(system, accountName, properties);
    }

    @Override
    public void putAccountPart(String system, String accountName, String credentialName, byte[] body) {
        accountManager.addCredential(system, accountName, credentialName, body);
    }

    @Override
    public void finishAccountInit(String system, String accountName) {
        accountManager.finishCreation(system, accountName);
    }

    @Override
    public void deleteAccount(String system, String accountName) {
        accountManager.delete(system, accountName);
    }
}
