package ru.yandex.personal.mail.search.metrics.scraper.controllers.error;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.controllers.error.exception.BadRequestException;
import ru.yandex.personal.mail.search.metrics.scraper.controllers.error.message.BadRequestErrorMessage;

@Service("badRequestExceptionMapper")
@Provider
public class BadRequestExceptionMapper implements ExceptionMapper<BadRequestException> {
    private static final Logger LOG = LoggerFactory.getLogger(BadRequestExceptionMapper.class);

    @Override
    public Response toResponse(BadRequestException exception) {
        LOG.info("Bad request exception: " + exception.getMessage());
        BadRequestErrorMessage brem = new BadRequestErrorMessage(exception);
        return Response.status(Response.Status.BAD_REQUEST).entity(brem).build();
    }
}
