package ru.yandex.personal.mail.search.metrics.scraper.controllers.error;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.controllers.error.message.GeneralErrorMessage;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.CrawlerException;

@Service("crawlerExceptionMapper")
@Provider
public class CrawlerExceptionMapper implements ExceptionMapper<CrawlerException> {
    private static final Logger LOG = LoggerFactory.getLogger(CrawlerExceptionMapper.class);

    @Override
    public Response toResponse(CrawlerException exception) {
        LOG.error("Unhandled scraper exception", exception);
        GeneralErrorMessage gem = new GeneralErrorMessage(exception);
        return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(gem).build();
    }
}
