package ru.yandex.personal.mail.search.metrics.scraper.controllers.error;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.controllers.error.message.GeneralErrorMessage;

@Service("generalExceptionMapper")
@Provider
public class GeneralExceptionMapper implements ExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralExceptionMapper.class);

    @Override
    public Response toResponse(Exception exception) {
        LOG.error("Unhandled exception", exception);
        GeneralErrorMessage gem = new GeneralErrorMessage(exception);
        return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(gem).build();
    }
}

