package ru.yandex.personal.mail.search.metrics.scraper.controllers.error.message;

import org.springframework.http.HttpStatus;

import ru.yandex.personal.mail.search.metrics.scraper.controllers.error.exception.BadRequestException;

public class BadRequestErrorMessage {
    private final String exception;
    private final String message;

    public BadRequestErrorMessage(BadRequestException e) {
        message = e.getMessage();
        exception = e.getClass().getSimpleName();
    }

    public String getMessage() {
        return message;
    }

    public String getException() {
        return exception;
    }

    public int getStatus() {
        return HttpStatus.BAD_REQUEST.value();
    }
}
