package ru.yandex.personal.mail.search.metrics.scraper.controllers.error.message;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class GeneralErrorMessage {
    private final String message;
    private final String exception;
    private final List<String> stackTraceTop10;

    public GeneralErrorMessage(Exception e) {
        message = e.getMessage();
        exception = e.getClass().getSimpleName();

        stackTraceTop10 = Arrays.stream(e.getStackTrace())
                .limit(10)
                .map(StackTraceElement::toString)
                .collect(Collectors.toList());
    }

    public String getMessage() {
        return message;
    }

    public String getException() {
        return exception;
    }

    public List<String> getStackTraceTop10() {
        return stackTraceTop10;
    }
}
