package ru.yandex.personal.mail.search.metrics.scraper.controllers.filters;

import java.net.URI;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;

import com.google.common.io.Files;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.AbstractSearchResult;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.Serp;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpComponent;

@Service("archiveLinkFilter")
@Provider
@ResolveArchiveLinks
public class ArchiveLinkFilter implements ContainerResponseFilter {

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        responseContext.getEntity();
        URI baseUri = requestContext.getUriInfo().getBaseUri();

        Object entity = responseContext.getEntity();
        if (entity instanceof Serp) {
            Serp serp = (Serp) entity;
            resolveUrls(baseUri, serp);
            responseContext.setEntity(serp);
        }
    }

    private void resolveUrls(URI baseUri, Serp serp) {
        resolveUrl(baseUri, serp);
        for (SerpComponent component : serp.getComponents()) {
            resolveUrl(baseUri, component);
        }
    }

    private void resolveUrl(URI baseUri, AbstractSearchResult parent) {
        if (parent.getArchivedResponseUrl() != null && !parent.getArchivedResponseUrl().isEmpty()) {
            String encoded = (parent.getArchivedResponseUrl()).replaceAll("\\.", "%2E");
            String extension = Files.getFileExtension(parent.getArchivedResponseUrl());

            if (extension.equals("html")) {
                parent.setArchivedResponseUrl(baseUri.resolve("api/archive/html/" + encoded + "/noscript").toString());
            } else {
                parent.setArchivedResponseUrl(baseUri.resolve("api/archive/" + extension + "/" + encoded).toString());
            }
        }

        if (parent.getArchivedScreenshotUrl() != null && !parent.getArchivedScreenshotUrl().isEmpty()) {
            String encoded = (parent.getArchivedScreenshotUrl()).replaceAll("\\.", "%2E");
            parent.setArchivedScreenshotUrl(baseUri.resolve("api/archive/screenshot/" + encoded).toString());
        }
    }
}
