package ru.yandex.personal.mail.search.metrics.scraper.controllers.mapping;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import ru.yandex.personal.mail.search.metrics.scraper.services.account.AccountProperties;
import ru.yandex.qe.bus.MediaTypeConstants;

@Path("/v1/account")
@Produces(MediaType.APPLICATION_JSON)
public interface AccountMapping {
    @PUT
    @Path("{system}/{accountName}")
    @Consumes(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
    void addAccount(
            @PathParam("system") String system,
            @PathParam("accountName") String accountName,
            AccountProperties properties);

    @POST
    @Path("{system}/{accountName}/{credentialName}")
    @Consumes("*/*")
    void putAccountPart(
            @PathParam("system") String system,
            @PathParam("accountName") String accountName,
            @PathParam("credentialName") String credentialName,
            byte[] body);

    @POST
    @Path("{system}/{accountName}")
    void finishAccountInit(
            @PathParam("system") String system,
            @PathParam("accountName") String accountName);

    @DELETE
    @Path("{system}/{accountName}")
    void deleteAccount(
            @PathParam("system") String system,
            @PathParam("accountName") String accountName);
}
