package ru.yandex.personal.mail.search.metrics.scraper.controllers.mapping;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.springframework.web.bind.annotation.GetMapping;

import ru.yandex.qe.bus.MediaTypeConstants;

@Path("/archive")
@Produces(MediaType.APPLICATION_JSON)
public interface ArchiveMapping {
    @GET
    @Path("/")
    @GetMapping
    @Produces(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
    List<String> getArchives(@Context HttpServletRequest request);

    @GET
    @Path("{archiveName}")
    @Produces(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
    List<String> getArchiveDates(
            @Context HttpServletRequest request,
            @PathParam("archiveName") String archiveName);

    @GET
    @Path("{archiveName}/{resourceDate}/{resourceId}")
    Response getArchive(
            @PathParam("archiveName") String archiveName,
            @PathParam("resourceId") String resourceId,
            @PathParam("resourceDate") String resourceDate);

    @GET
    @Path("{archiveName}/{resourceDate}/{resourceId}/noscript")
    Response getScriptlessResponse(
            @PathParam("archiveName") String archiveName,
            @PathParam("resourceId") String resourceId,
            @PathParam("resourceDate") String resourceDate);
}
