package ru.yandex.personal.mail.search.metrics.scraper.controllers.mapping;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import ru.yandex.personal.mail.search.metrics.scraper.controllers.filters.ResolveArchiveLinks;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.basket.BasketQuery;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.Serp;
import ru.yandex.qe.bus.MediaTypeConstants;

@Path("/v1/search/")
@Produces(MediaType.APPLICATION_JSON)
public interface SearchMapping {
    @POST
    @Path("{system}/{accountName}")
    @ResolveArchiveLinks
    @Produces(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
    @Consumes(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
    Serp search(
            @PathParam("system") String system,
            @PathParam("accountName") String accountName,
            BasketQuery query);

    @GET
    @Path("{system}/{accountName}/{query}")
    @ResolveArchiveLinks
    @Produces(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
    Serp searchGet(
            @PathParam("system") String system,
            @PathParam("accountName") String accountName,
            @PathParam("query") String query);
}
