package ru.yandex.personal.mail.search.metrics.scraper.metrics;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.basket.BasketQuery;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.Serp;
import ru.yandex.personal.mail.search.metrics.scraper.services.evaluation.Evaluation;

public class MarkedSearchService implements MetricsCompatibleMailSystem {
    private final MetricsCompatibleMailSystem service;
    private final Evaluation evaluation;

    public MarkedSearchService(MetricsCompatibleMailSystem service, Evaluation evaluation) {
        this.service = service;
        this.evaluation = evaluation;
    }

    @Override
    public Serp search(BasketQuery query) {
        Serp serp = service.search(query);
        serp.setComponents(evaluation.markedSerpComponentns(serp, query));
        return serp;
    }

    @Override
    public void logout() {
        service.logout();
    }
}
