package ru.yandex.personal.mail.search.metrics.scraper.metrics;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.plugin.core.SimplePluginRegistry;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.compatibility.MetricsCompatibility;
import ru.yandex.personal.mail.search.metrics.scraper.services.account.AccountInfo;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystemLoader;

@Service
public class MetricsSystemLoaderRegistry {
    private final PluginRegistry<MetricsSystemLoader, String> registry;

    @Autowired
    public MetricsSystemLoaderRegistry(
            List<MailSearchSystemLoader> searchLoaders,
            List<MailSuggestSystemLoader> suggestLoaders
    )
    {
        List<MetricsSystemLoader> metricLoadersList = new ArrayList<>();

        for (MailSearchSystemLoader systemLoader : searchLoaders) {
            metricLoadersList.add(MetricsCompatibility.adapt(systemLoader));
        }

        for (MailSuggestSystemLoader systemLoader : suggestLoaders) {
            metricLoadersList.add(MetricsCompatibility.adapt(systemLoader));
        }

        registry = SimplePluginRegistry.create(metricLoadersList);
    }

    public MetricsSystemLoader getLoader(String name) {
        if (registry.hasPluginFor(name)) {
            return registry.getPluginFor(name);
        } else {
            throw new IllegalStateException("System " + name + " is not supported!");
        }
    }

    public MetricsSystemLoader getForInfo(AccountInfo accountInfo) {
        return getLoader(accountInfo.getSystemName());
    }
}
