package ru.yandex.personal.mail.search.metrics.scraper.metrics.basket;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.personal.mail.search.metrics.scraper.model.query.SearchQuery;

@JsonIgnoreProperties(ignoreUnknown = true)
public class BasketQuery implements SearchQuery {
    @JsonProperty("text")
    private String text;
    @JsonProperty("labels")
    private List<String> relevantIds;

    public BasketQuery() {
    }

    public BasketQuery(String text) {
        this(text, Collections.emptyList());
    }

    public BasketQuery(String text, List<String> relevantIds) {
        this.text = text;
        this.relevantIds = relevantIds;
    }

    @Override
    public String getText() {
        return text;
    }

    public List<String> getRelevantIds() {
        return relevantIds;
    }
}
