package ru.yandex.personal.mail.search.metrics.scraper.metrics.compatibility;

import java.nio.file.Path;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.MarkedSearchService;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.MetricsCompatibleMailSystem;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.MetricsSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.evaluation.SerpEvaluation;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystemLoader;

class MailSearchServiceLoaderMetricsAdapter implements MetricsSystemLoader {
    private final MailSearchSystemLoader loader;

    MailSearchServiceLoaderMetricsAdapter(MailSearchSystemLoader loader) {
        this.loader = loader;
    }

    @Override
    public boolean supports(String systemName) {
        return loader.supports(systemName);
    }

    @Override
    public boolean validateCredentialName(String credentialName) {
        return loader.validateCredentialName(credentialName);
    }

    @Override
    public MetricsCompatibleMailSystem load(Path accPath) {
        MetricsCompatibleMailSystem adapted = MetricsCompatibility.adapt(loader.load(accPath));
        return new MarkedSearchService(adapted, new SerpEvaluation());
    }
}
