package ru.yandex.personal.mail.search.metrics.scraper.metrics.compatibility;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.MetricsCompatibleMailSystem;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.basket.BasketQuery;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.Serp;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpComponent;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpHeaders;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpInfo;
import ru.yandex.personal.mail.search.metrics.scraper.model.crawling.CrawlingMeta;
import ru.yandex.personal.mail.search.metrics.scraper.model.mail.ArchivedMailScrapingResult;
import ru.yandex.personal.mail.search.metrics.scraper.model.mail.search.MailSearchMessageSnippet;
import ru.yandex.personal.mail.search.metrics.scraper.model.mail.search.MailSearchResult;
import ru.yandex.personal.mail.search.metrics.scraper.model.query.FullSearchQuery;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.ArchiveEntry;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystem;

class MailSearchServiceMetricsAdapter implements MetricsCompatibleMailSystem {
    private final MailSearchSystem searchService;

    MailSearchServiceMetricsAdapter(MailSearchSystem suggestService) {
        this.searchService = suggestService;
    }

    @Override
    public Serp search(BasketQuery query) {
        return mailSearchResultToSerp(searchService.search(query));
    }

    private Serp mailSearchResultToSerp(MailSearchResult msr) {
        List<SerpComponent> components = msr.getScrapedData().getSnippets().stream()
                .map(this::fromMessageSearchSnippet)
                .collect(Collectors.toList());

        FullSearchQuery query = new FullSearchQuery(msr.getSearchQuery().getText());

        ArchivedMailScrapingResult scrapingResult = msr.getArchivedMailScrapingResult();
        String archivedResponseUrl = Optional.ofNullable(scrapingResult.getResponse())
                .map(ArchiveEntry::getId).orElse(null);
        String archivedScreenshotUrl = Optional.ofNullable(scrapingResult.getScreenshot())
                .map(ArchiveEntry::getId).orElse(null);

        SerpHeaders headers = new SerpHeaders(msr.getScrapedData().getFoundAllAverageSize());
        CrawlingMeta cm = msr.getCrawlingMeta();
        SerpInfo serpInfo = new SerpInfo(cm.getTimeTaken(), cm.getResponseDataSize());

        return new Serp(archivedResponseUrl, archivedScreenshotUrl, headers, serpInfo, components, query);
    }

    private SerpComponent fromMessageSearchSnippet(MailSearchMessageSnippet snippet) {
        return SerpComponent
                .searchComponent(snippet.getSender(), snippet.getSubject(), snippet.getSnippet(), snippet.getDate());
    }

    @Override
    public void logout() {
        searchService.logout();
    }
}
