package ru.yandex.personal.mail.search.metrics.scraper.metrics.compatibility;

import java.nio.file.Path;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.MetricsCompatibleMailSystem;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.MetricsSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystemLoader;

class MailSuggestServiceLoaderMetricsAdapter implements MetricsSystemLoader {
    private final MailSuggestSystemLoader loader;

    MailSuggestServiceLoaderMetricsAdapter(MailSuggestSystemLoader loader) {
        this.loader = loader;
    }

    @Override
    public boolean supports(String systemName) {
        return loader.supports(systemName);
    }

    @Override
    public boolean validateCredentialName(String credentialName) {
        return loader.validateCredentialName(credentialName);
    }

    @Override
    public MetricsCompatibleMailSystem load(Path accPath) {
        return MetricsCompatibility.adapt(loader.load(accPath));
    }
}
