package ru.yandex.personal.mail.search.metrics.scraper.metrics.compatibility;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.MetricsCompatibleMailSystem;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.basket.BasketQuery;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.Serp;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpComponent;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpComponentSitelink;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpHeaders;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpInfo;
import ru.yandex.personal.mail.search.metrics.scraper.model.crawling.CrawlingMeta;
import ru.yandex.personal.mail.search.metrics.scraper.model.mail.suggest.MailSuggestPartResult;
import ru.yandex.personal.mail.search.metrics.scraper.model.mail.suggest.MailSuggestResult;
import ru.yandex.personal.mail.search.metrics.scraper.model.mail.suggest.MailSuggestSnippet;
import ru.yandex.personal.mail.search.metrics.scraper.model.query.FullSearchQuery;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystem;

class MailSuggestServiceMetricsAdapter implements MetricsCompatibleMailSystem {
    private final MailSuggestSystem suggestSystem;

    MailSuggestServiceMetricsAdapter(MailSuggestSystem suggestSystem) {
        this.suggestSystem = suggestSystem;
    }

    @Override
    public Serp search(BasketQuery query) {
        return mailSuggestResultToSerp(suggestSystem.suggest(query));
    }

    private Serp mailSuggestResultToSerp(MailSuggestResult msr) {
        List<SerpComponent> components = msr.getSuggestResults().stream()
                .map(this::fromSymbolSuggestResult)
                .collect(Collectors.toList());

        return Serp.suggestResult(components, new FullSearchQuery(msr.getQuery().getText()));
    }

    private SerpComponent fromSymbolSuggestResult(MailSuggestPartResult ssr) {
        List<SerpComponentSitelink> sitelinks = ssr.getSnippets().stream()
                .map(this::fromMailSuggestSnippet)
                .collect(Collectors.toList());

        SerpComponent component = SerpComponent.suggestComponent(ssr.getQueryPart().getPart(), sitelinks);

        if (ssr.getArchivedMailScrapingResult().getResponse() != null) {
            component.setArchivedResponseUrl(ssr.getArchivedMailScrapingResult().getResponse().getId());
        }

        if (ssr.getArchivedMailScrapingResult().getScreenshot() != null) {
            component.setArchivedScreenshotUrl(ssr.getArchivedMailScrapingResult().getScreenshot().getId());
        }

        SerpHeaders headers = new SerpHeaders(ssr.getSnippets().size());

        CrawlingMeta cm = ssr.getCrawlingMeta();
        SerpInfo serpInfo = new SerpInfo(cm.getTimeTaken(), cm.getResponseDataSize());

        component.setHeaders(headers);
        component.setSerpInfo(serpInfo);

        return component;
    }

    private SerpComponentSitelink fromMailSuggestSnippet(MailSuggestSnippet mss) {
        return SerpComponentSitelink.suggestSnippet(mss.getText());
    }

    @Override
    public void logout() {
        suggestSystem.logout();
    }
}
