package ru.yandex.personal.mail.search.metrics.scraper.metrics.compatibility;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.MetricsCompatibleMailSystem;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.MetricsSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystem;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystem;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystemLoader;

public class MetricsCompatibility {
    private MetricsCompatibility() {
    }

    public static MetricsCompatibleMailSystem adapt(MailSearchSystem searchService) {
        return new MailSearchServiceMetricsAdapter(searchService);
    }

    public static MetricsCompatibleMailSystem adapt(MailSuggestSystem suggestService) {
        return new MailSuggestServiceMetricsAdapter(suggestService);
    }

    public static MetricsSystemLoader adapt(MailSearchSystemLoader searchServiceLoader) {
        return new MailSearchServiceLoaderMetricsAdapter(searchServiceLoader);
    }

    public static MetricsSystemLoader adapt(MailSuggestSystemLoader suggestServiceLoader) {
        return new MailSuggestServiceLoaderMetricsAdapter(suggestServiceLoader);
    }
}
