package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class AbstractSearchResult {

    @JsonProperty("type")
    private String type;

    @JsonProperty("url.response")
    private String archivedResponseUrl;

    @JsonProperty("url.screenshot")
    private String archivedScreenshotUrl;

    @JsonProperty("headers")
    private SerpHeaders headers;

    @JsonProperty("serpInfo")
    private SerpInfo serpInfo;

    AbstractSearchResult(String type) {
        this.type = type;
    }

    AbstractSearchResult(AbstractSearchResult searchParent) {
        this.type = searchParent.type;
        this.archivedResponseUrl = searchParent.archivedResponseUrl;
        this.archivedScreenshotUrl = searchParent.archivedScreenshotUrl;
        this.headers = searchParent.headers;
        this.serpInfo = searchParent.serpInfo;
    }

    AbstractSearchResult(String type, String archivedResponseUrl, String archivedScreenshotUrl,
            SerpHeaders headers, SerpInfo serpInfo)
    {
        this.type = type;
        this.archivedResponseUrl = archivedResponseUrl;
        this.archivedScreenshotUrl = archivedScreenshotUrl;
        this.headers = headers;
        this.serpInfo = serpInfo;
    }

    public String getType() {
        return type;
    }

    public String getArchivedResponseUrl() {
        return archivedResponseUrl;
    }

    public void setArchivedResponseUrl(String archivedResponseUrl) {
        this.archivedResponseUrl = archivedResponseUrl;
    }

    public String getArchivedScreenshotUrl() {
        return archivedScreenshotUrl;
    }

    public void setArchivedScreenshotUrl(String archivedScreenshotUrl) {
        this.archivedScreenshotUrl = archivedScreenshotUrl;
    }

    public SerpHeaders getHeaders() {
        return headers;
    }

    public void setHeaders(SerpHeaders headers) {
        this.headers = headers;
    }

    public SerpInfo getSerpInfo() {
        return serpInfo;
    }

    public void setSerpInfo(SerpInfo serpInfo) {
        this.serpInfo = serpInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AbstractSearchResult that = (AbstractSearchResult) o;
        return Objects.equal(type, that.type) &&
                Objects.equal(archivedResponseUrl, that.archivedResponseUrl) &&
                Objects.equal(archivedScreenshotUrl, that.archivedScreenshotUrl) &&
                Objects.equal(headers, that.headers) &&
                Objects.equal(serpInfo, that.serpInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(type, archivedResponseUrl, archivedScreenshotUrl, headers, serpInfo);
    }

    @Override
    public String toString() {
        return "SearchParent{" +
                "type='" + type + '\'' +
                ", archivedResponseUrl='" + archivedResponseUrl + '\'' +
                ", archivedScreenshotUrl='" + archivedScreenshotUrl + '\'' +
                ", headers=" + headers +
                ", serpInfo=" + serpInfo +
                '}';
    }
}
