package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

import ru.yandex.personal.mail.search.metrics.scraper.model.query.FullSearchQuery;


@JsonInclude(JsonInclude.Include.NON_NULL)
public class Serp extends AbstractSearchResult {
    private static final String TYPE = "SERP";

    @JsonProperty("components")
    private List<SerpComponent> components;
    @JsonProperty("query")
    private FullSearchQuery query;

    public Serp(String archivedResponseUrl, String archivedScreenshotUrl,
            SerpHeaders headers, SerpInfo serpInfo,
            List<SerpComponent> components,
            FullSearchQuery query)
    {
        super(TYPE, archivedResponseUrl, archivedScreenshotUrl, headers, serpInfo);
        this.components = components;
        this.query = query;
    }

    public static Serp suggestResult(List<SerpComponent> components, FullSearchQuery query) {
        return new Serp(null, null, null, null, components, query);
    }

    public void setComponents(List<SerpComponent> components) {
        this.components = components;
    }

    public void setQuery(FullSearchQuery query) {
        this.query = query;
    }

    public List<SerpComponent> getComponents() {
        return this.components;
    }

    public FullSearchQuery getQuery() {
        return this.query;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Serp serp = (Serp) o;
        return Objects.equal(components, serp.components) &&
                Objects.equal(query, serp.query);
    }

    @Override
    public String toString() {
        return "Serp{" +
                "components=" + components +
                ", query=" + query +
                '}';
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(components, query);
    }
}
