package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import java.time.Instant;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SerpComponent extends AbstractSearchResult {
    private static final String TYPE = "COMPONENT";

    @JsonProperty("componentInfo")
    private SerpComponentInfo componentInfo = new SerpComponentInfo();
    @JsonProperty("text.title")
    private String title;
    @JsonProperty("text.snippet")
    private String snippet;
    @JsonProperty("json.serpData")
    private SerpData serpData;
    @JsonProperty("judgements.marker_test_result")
    private SerpJudgement testResult;
    @JsonProperty("site-links")
    private List<SerpComponentSitelink> sitelinks;

    public SerpComponent(String title, String snippet, SerpData serpData, SerpJudgement testResult,
            List<SerpComponentSitelink> sitelinks)
    {
        super(TYPE);
        this.title = title;
        this.snippet = snippet;
        this.serpData = serpData;
        this.testResult = testResult;
        this.sitelinks = sitelinks;
    }

    public static SerpComponent searchComponent(String sender, String subject, String snippet, Instant date) {
        return new SerpComponent(subject, snippet, new SerpData(date, sender), null, null);
    }

    public static SerpComponent suggestComponent(String queryPart, List<SerpComponentSitelink> sitelinks) {
        return new SerpComponent(queryPart, "", new SerpData(Instant.EPOCH, ""), null, sitelinks);
    }

    public SerpComponent withTestResult(SerpJudgement testResult) {
        return new SerpComponent(title, snippet, serpData, testResult, sitelinks);
    }

    public List<SerpComponentSitelink> getSitelinks() {
        return sitelinks;
    }

    public String getSnippet() {
        return snippet;
    }

    public SerpJudgement getTestResult() {
        return testResult;
    }

    public SerpData getSerpData() {
        return this.serpData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SerpComponent that = (SerpComponent) o;
        return Objects.equals(componentInfo, that.componentInfo) &&
                Objects.equals(title, that.title) &&
                Objects.equals(snippet, that.snippet) &&
                Objects.equals(serpData, that.serpData) &&
                Objects.equals(testResult, that.testResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(componentInfo, title, snippet, serpData, testResult);
    }

    @Override
    public String toString() {
        return "SerpComponent{" +
                "componentInfo=" + componentInfo +
                ", subject='" + title + '\'' +
                ", snippet='" + snippet + '\'' +
                ", serpData=" + serpData +
                ", testResult=" + testResult +
                '}';
    }
}
