package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

class SerpComponentInfo {
    // https://wiki.yandex-team.ru/jandekspoisk/metrics/api/serp/#primerkartinochnogoserpa
    private static final int SEARCH_RESULT = 1;

    // https://wiki.yandex-team.ru/jandekspoisk/metrics/api/serp/#primerkartinochnogoserpa
    @JsonProperty("type")
    private Integer type = SEARCH_RESULT;

    public Integer getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SerpComponentInfo that = (SerpComponentInfo) o;
        return Objects.equals(type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type);
    }

    public String toString() {
        return "SerpComponentInfo(type=" + this.getType() + ")";
    }
}
