package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SerpComponentSitelink {
    @JsonProperty("type")
    private String type = "SITELINK";
    @JsonProperty("sitelinks")
    private SerpComponentSitelinkContent content;

    public SerpComponentSitelink() {
    }

    public SerpComponentSitelink(String snippet, SerpJudgement testResult) {
        content = new SerpComponentSitelinkContent(snippet, testResult);
    }

    public static SerpComponentSitelink suggestSnippet(String snippet) {
        return new SerpComponentSitelink(snippet, null);
    }

    @Override
    public String toString() {
        return "SerpComponentSitelink{" +
                "type='" + type + '\'' +
                ", content=" + content +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SerpComponentSitelink that = (SerpComponentSitelink) o;
        return Objects.equal(type, that.type) &&
                Objects.equal(content, that.content);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(type, content);
    }
}
