package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SerpComponentSitelinkContent {
    @JsonProperty("title")
    private String snippet;
    @JsonProperty("judgements.marker_test_result")
    private SerpJudgement testResult = null;

    public SerpComponentSitelinkContent() {
    }

    public SerpComponentSitelinkContent(String snippet,
            SerpJudgement testResult)
    {
        this.snippet = snippet;
        this.testResult = testResult;
    }

    public String getSnippet() {
        return snippet;
    }

    public void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    public SerpJudgement getTestResult() {
        return testResult;
    }

    public void setTestResult(SerpJudgement testResult) {
        this.testResult = testResult;
    }

    @Override
    public String toString() {
        return "SerpComponentSitelinkContent{" +
                "snippet='" + snippet + '\'' +
                ", testResult=" + testResult +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SerpComponentSitelinkContent that = (SerpComponentSitelinkContent) o;
        return Objects.equal(snippet, that.snippet) &&
                Objects.equal(testResult, that.testResult);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(snippet, testResult);
    }
}
