package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import java.time.Instant;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class SerpData {
    @JsonProperty("date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "UTC")
    private Instant date;
    @JsonProperty("sender")
    private String sender;
    @JsonProperty("id")
    private String id;

    public SerpData() {
    }

    SerpData(Instant date, String sender) {
        this.date = date;
        this.sender = sender;
        this.id = "" + date.getEpochSecond();
    }

    public Instant getDate() {
        return this.date;
    }

    public String getSender() {
        return this.sender;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SerpData serpData = (SerpData) o;
        return Objects.equals(date, serpData.date) &&
                Objects.equals(sender, serpData.sender) &&
                Objects.equals(id, serpData.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, sender, id);
    }

    @Override
    public String toString() {
        return "SerpData{" +
                "date=" + date +
                ", sender='" + sender + '\'' +
                ", id='" + id + '\'' +
                '}';
    }
}
