package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class SerpHeaders {
    @JsonProperty("foundDocumentsCount")
    private Integer foundDocumentsCount;
    @JsonProperty("headers")
    private List<Object> httpHeaders = Collections.emptyList();

    public SerpHeaders() {
    }

    public SerpHeaders(Integer foundDocumentsCount) {
        this.foundDocumentsCount = foundDocumentsCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SerpHeaders that = (SerpHeaders) o;
        return Objects.equals(foundDocumentsCount, that.foundDocumentsCount) &&
                Objects.equals(httpHeaders, that.httpHeaders);
    }

    @Override
    public int hashCode() {
        return Objects.hash(foundDocumentsCount, httpHeaders);
    }

    @Override
    public String toString() {
        return "SerpHeaders{" +
                "foundDocumentsCount=" + foundDocumentsCount +
                ", httpHeaders=" + httpHeaders +
                '}';
    }
}
