package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SerpInfo {
    @JsonProperty("responseTime")
    private Long responseTime;
    @JsonProperty("responseSize")
    private Integer responseSize;

    public SerpInfo(Long responseTime, Integer responseSize) {
        this.responseTime = responseTime;
        this.responseSize = responseSize;
    }

    public SerpInfo() {
    }

    public Long getResponseTime() {
        return responseTime;
    }

    public void setResponseTime(Long responseTime) {
        this.responseTime = responseTime;
    }

    public Integer getResponseSize() {
        return responseSize;
    }

    public void setResponseSize(Integer responseSize) {
        this.responseSize = responseSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SerpInfo serpInfo = (SerpInfo) o;
        return Objects.equal(responseTime, serpInfo.responseTime) &&
                Objects.equal(responseSize, serpInfo.responseSize);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(responseTime, responseSize);
    }

    @Override
    public String toString() {
        return "SerpInfo{" +
                "responseTime=" + responseTime +
                ", responseSize=" + responseSize +
                '}';
    }
}
