package ru.yandex.personal.mail.search.metrics.scraper.metrics.serp;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public final class SerpJudgement {
    public static final SerpJudgement FAILED = new SerpJudgement("FAILED");
    public static final SerpJudgement PASSED = new SerpJudgement("PASSED");

    @JsonProperty("name")
    private String state;
    @JsonProperty("scale")
    private String scale = "marker_test_result";

    private SerpJudgement(String state) {
        this.state = state;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SerpJudgement that = (SerpJudgement) o;
        return Objects.equals(state, that.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(state, scale);
    }

    @Override
    public String toString() {
        return "SerpJudgement{" +
                "state='" + state + '\'' +
                ", scale='" + scale + '\'' +
                '}';
    }
}
