package ru.yandex.personal.mail.search.metrics.scraper.model.mail;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.ArchiveEntry;

public class ArchivedMailScrapingResult {
    private final ArchiveEntry screenshot;
    private final ArchiveEntry response;

    public ArchivedMailScrapingResult(ArchiveEntry screenshot, ArchiveEntry response) {
        this.screenshot = screenshot;
        this.response = response;
    }

    public static ArchivedMailScrapingResult responseOnly(ArchiveEntry response) {
        return new ArchivedMailScrapingResult(null, response);
    }

    public ArchiveEntry getScreenshot() {
        return screenshot;
    }

    public ArchiveEntry getResponse() {
        return response;
    }
}
