package ru.yandex.personal.mail.search.metrics.scraper.model.mail.search;

import java.time.Instant;

import com.google.common.base.Objects;

public class MailSearchMessageSnippet {
    private final String subject;
    private final String snippet;
    private final String sender;
    private final Instant date;

    public MailSearchMessageSnippet(String subject, String snippet, String sender, Instant date) {
        this.subject = subject;
        this.snippet = snippet;
        this.sender = sender;
        this.date = date;
    }

    public String getSubject() {
        return subject;
    }

    public String getSnippet() {
        return snippet;
    }

    public String getSender() {
        return sender;
    }

    public Instant getDate() {
        return date;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailSearchMessageSnippet)) {
            return false;
        }
        MailSearchMessageSnippet that = (MailSearchMessageSnippet) o;
        return Objects.equal(subject, that.subject) &&
                Objects.equal(snippet, that.snippet) &&
                Objects.equal(sender, that.sender) &&
                Objects.equal(date, that.date);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(subject, snippet, sender, date);
    }

    @Override
    public String toString() {
        return "MailSearchMessageSnippet{" +
                "subject='" + subject + '\'' +
                ", snippet='" + snippet + '\'' +
                ", sender='" + sender + '\'' +
                ", date=" + date +
                '}';
    }
}
