package ru.yandex.personal.mail.search.metrics.scraper.model.mail.search;

import ru.yandex.personal.mail.search.metrics.scraper.model.crawling.CrawlingError;
import ru.yandex.personal.mail.search.metrics.scraper.model.crawling.CrawlingMeta;
import ru.yandex.personal.mail.search.metrics.scraper.model.mail.ArchivedMailScrapingResult;
import ru.yandex.personal.mail.search.metrics.scraper.model.query.SearchQuery;

public class MailSearchResult {
    private final SearchQuery searchQuery;
    private final MailSearchScrapedData scrapedData;
    private final ArchivedMailScrapingResult archivedMailScrapingResult;
    private final CrawlingMeta crawlingMeta;
    private final CrawlingError error;

    public MailSearchResult(
            SearchQuery searchQuery,
            MailSearchScrapedData scrapedData,
            ArchivedMailScrapingResult archivedMailScrapingResult,
            CrawlingMeta crawlingMeta, CrawlingError error)
    {
        this.searchQuery = searchQuery;
        this.scrapedData = scrapedData;
        this.archivedMailScrapingResult = archivedMailScrapingResult;
        this.crawlingMeta = crawlingMeta;
        this.error = error;
    }

    public static MailSearchResult successful(
            SearchQuery searchQuery,
            MailSearchScrapedData scrapedData,
            ArchivedMailScrapingResult archivedMailScrapingResult,
            CrawlingMeta crawlingMeta)
    {
        return new MailSearchResult(searchQuery, scrapedData, archivedMailScrapingResult, crawlingMeta, null);
    }

    public SearchQuery getSearchQuery() {
        return searchQuery;
    }

    public ArchivedMailScrapingResult getArchivedMailScrapingResult() {
        return archivedMailScrapingResult;
    }

    public CrawlingError getError() {
        return error;
    }

    public MailSearchScrapedData getScrapedData() {
        return scrapedData;
    }

    public CrawlingMeta getCrawlingMeta() {
        return crawlingMeta;
    }
}
