package ru.yandex.personal.mail.search.metrics.scraper.model.mail.search;

import java.util.Collections;
import java.util.List;

import com.google.common.base.Objects;

public class MailSearchScrapedData {
    private final int foundAllAverageSize;
    private final List<MailSearchMessageSnippet> snippets;

    public MailSearchScrapedData(int foundAllAverageSize, List<MailSearchMessageSnippet> snippets) {
        this.foundAllAverageSize = foundAllAverageSize;
        this.snippets = snippets;
    }

    public static MailSearchScrapedData empty() {
        return new MailSearchScrapedData(0, Collections.emptyList());
    }

    public int getFoundAllAverageSize() {
        return foundAllAverageSize;
    }

    public List<MailSearchMessageSnippet> getSnippets() {
        return snippets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailSearchScrapedData)) {
            return false;
        }
        MailSearchScrapedData that = (MailSearchScrapedData) o;
        return foundAllAverageSize == that.foundAllAverageSize &&
                Objects.equal(snippets, that.snippets);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(foundAllAverageSize, snippets);
    }
}
