package ru.yandex.personal.mail.search.metrics.scraper.model.mail.suggest;

import java.util.List;

import ru.yandex.personal.mail.search.metrics.scraper.model.crawling.CrawlingError;
import ru.yandex.personal.mail.search.metrics.scraper.model.crawling.CrawlingMeta;
import ru.yandex.personal.mail.search.metrics.scraper.model.mail.ArchivedMailScrapingResult;
import ru.yandex.personal.mail.search.metrics.scraper.model.query.SearchQuery;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.suggest.querysplitters.QueryPart;

public class MailSuggestPartResult {
    private final SearchQuery fullQuery;
    private final QueryPart queryPart;

    private final int enteredSize;
    private final double enteredPart;

    private final CrawlingMeta crawlingMeta;
    private final ArchivedMailScrapingResult archivedMailScrapingResult;
    private final CrawlingError error;

    private final List<MailSuggestSnippet> snippets;

    public MailSuggestPartResult(
            SearchQuery fullQuery,
            QueryPart queryPart,
            int enteredSize,
            double enteredPart,
            CrawlingMeta crawlingMeta,
            ArchivedMailScrapingResult archivedMailScrapingResult,
            CrawlingError error,
            List<MailSuggestSnippet> snippets)
    {
        this.fullQuery = fullQuery;
        this.queryPart = queryPart;
        this.enteredSize = enteredSize;
        this.enteredPart = enteredPart;
        this.crawlingMeta = crawlingMeta;
        this.archivedMailScrapingResult = archivedMailScrapingResult;
        this.error = error;
        this.snippets = snippets;
    }

    public static MailSuggestPartResult successful(
            SearchQuery fullQuery,
            QueryPart queryPart,
            CrawlingMeta statistics,
            ArchivedMailScrapingResult archivedMailScrapingResult,
            List<MailSuggestSnippet> snippets)
    {
        return new MailSuggestPartResult(
                fullQuery,
                queryPart,
                queryPart.getPart().length(),
                fullQuery.getText().length() / (double) queryPart.getPart().length(),
                statistics,
                archivedMailScrapingResult,
                null,
                snippets
        );
    }

    public static MailSuggestPartResult failed(
            CrawlingError error,
            SearchQuery fullQuery,
            QueryPart queryPart,
            CrawlingMeta statistics,
            ArchivedMailScrapingResult archivedMailScrapingResult,
            List<MailSuggestSnippet> snippets
    )
    {
        return new MailSuggestPartResult(
                fullQuery,
                queryPart,
                queryPart.getPart().length(),
                fullQuery.getText().length() / (double) queryPart.getPart().length(),
                statistics,
                archivedMailScrapingResult,
                error,
                snippets
        );
    }

    public SearchQuery getFullQuery() {
        return fullQuery;
    }

    public int getEnteredSize() {
        return enteredSize;
    }

    public double getEnteredPart() {
        return enteredPart;
    }

    public ArchivedMailScrapingResult getArchivedMailScrapingResult() {
        return archivedMailScrapingResult;
    }

    public CrawlingError getError() {
        return error;
    }

    public List<MailSuggestSnippet> getSnippets() {
        return snippets;
    }

    public QueryPart getQueryPart() {
        return queryPart;
    }

    public CrawlingMeta getCrawlingMeta() {
        return crawlingMeta;
    }
}
