package ru.yandex.personal.mail.search.metrics.scraper.model.mail.suggest;

import java.util.List;

import ru.yandex.personal.mail.search.metrics.scraper.model.crawling.CrawlingError;
import ru.yandex.personal.mail.search.metrics.scraper.model.query.SearchQuery;

public class MailSuggestResult {
    private final SearchQuery query;
    private final List<MailSuggestPartResult> suggestResults;
    private final CrawlingError error;

    public MailSuggestResult(SearchQuery query,
            List<MailSuggestPartResult> suggestResults,
            CrawlingError error)
    {
        this.query = query;
        this.suggestResults = suggestResults;
        this.error = error;
    }

    public static MailSuggestResult successful(SearchQuery query,
            List<MailSuggestPartResult> suggestResults)
    {
        return new MailSuggestResult(query, suggestResults, null);
    }

    public SearchQuery getQuery() {
        return query;
    }

    public List<MailSuggestPartResult> getSuggestResults() {
        return suggestResults;
    }

    public CrawlingError getError() {
        return error;
    }
}
