package ru.yandex.personal.mail.search.metrics.scraper.model.mail.suggest;

public class MailSuggestSnippet {
    private final MailSuggestType type;
    private final String text;
    private final String highlightedText;

    private MailSuggestSnippet(MailSuggestType type, String text, String highlightedText) {
        this.type = type;
        this.text = text;
        this.highlightedText = highlightedText;
    }

    public static MailSuggestSnippet simple(String text) {
        return new MailSuggestSnippet(MailSuggestType.ALL, text, null);
    }

    public MailSuggestType getType() {
        return type;
    }

    public String getText() {
        return text;
    }

    public String getHighlightedText() {
        return highlightedText;
    }
}
