package ru.yandex.personal.mail.search.metrics.scraper.model.query;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class FullSearchQuery implements SearchQuery {
    private static final String RUSSIA = "RU";
    private static final int DESKTOP = 0;
    private static final int MOSCOW = 213;

    @JsonProperty("country")
    private String country = RUSSIA;
    @JsonProperty("device")
    private Integer device = DESKTOP;
    @JsonProperty("regionId")
    private Integer regionId = MOSCOW;
    @JsonProperty("text")
    private String text;

    public FullSearchQuery(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        FullSearchQuery that = (FullSearchQuery) o;
        return Objects.equals(device, that.device) &&
                Objects.equals(regionId, that.regionId) &&
                Objects.equals(text, that.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(country, device, regionId, text);
    }

    @Override
    public String toString() {
        return "FullSearchQuery{" +
                "country='" + country + '\'' +
                ", device=" + device +
                ", regionId=" + regionId +
                ", text='" + text + '\'' +
                '}';
    }
}
