package ru.yandex.personal.mail.search.metrics.scraper.services.account;

import java.nio.file.Path;

import com.google.common.base.Objects;

public class AccountConfiguration extends AccountInfo {
    private final Path accountPath;

    public AccountConfiguration(String serviceName, String accountName, Path accountPath) {
        super(serviceName, accountName);
        this.accountPath = accountPath;
    }

    public static AccountConfiguration fromInfo(AccountInfo info, Path accountPath) {
        return new AccountConfiguration(info.getSystemName(), info.getAccountName(), accountPath);
    }

    public Path getAccountPath() {
        return accountPath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountConfiguration)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccountConfiguration that = (AccountConfiguration) o;
        return Objects.equal(accountPath, that.accountPath);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), accountPath);
    }
}
