package ru.yandex.personal.mail.search.metrics.scraper.services.account;

import java.util.HashMap;
import java.util.Map;

public class AccountDraft {
    private final String system;
    private final String accountName;
    private final AccountProperties properties;

    private final Map<String, byte[]> credentials = new HashMap<>();

    public AccountDraft(String system, String accountName, AccountProperties properties) {
        this.system = system;
        this.accountName = accountName;
        this.properties = properties;
    }

    public AccountDraft(AccountInfo accountInfo, AccountProperties properties) {
        this.system = accountInfo.getSystemName();
        this.accountName = accountInfo.getAccountName();
        this.properties = properties;
    }

    public void addCredential(String credentialName, byte[] credentialBinary) {
        credentials.put(credentialName, credentialBinary);
    }

    public String getSystemName() {
        return system;
    }

    public String getAccountName() {
        return accountName;
    }

    public Map<String, byte[]> getCredentials() {
        return credentials;
    }

    public AccountProperties getProperties() {
        return properties;
    }
}
