package ru.yandex.personal.mail.search.metrics.scraper.services.account;

import ru.yandex.personal.mail.search.metrics.scraper.controllers.error.exception.BadRequestException;

public class AccountException extends BadRequestException {
    private final AccountInfo account;

    public AccountException(AccountInfo account) {
        this.account = account;
    }

    public AccountException(AccountInfo account, String message) {
        super(message);
        this.account = account;
    }

    public AccountException(AccountInfo account, String message, Throwable cause) {
        super(message, cause);
        this.account = account;
    }

    public AccountException(AccountInfo account, Throwable cause) {
        super(cause);
        this.account = account;
    }

    @Override
    public String getMessage() {
        return account.toString() + " " + super.getMessage();
    }
}
