package ru.yandex.personal.mail.search.metrics.scraper.services.account;

import java.util.Objects;

public class AccountInfo {
    private final String systemName;
    private final String accountName;

    public AccountInfo(String serviceName, String accountName) {
        this.systemName = serviceName;
        this.accountName = accountName;
    }

    public String getSystemName() {
        return systemName;
    }

    public String getAccountName() {
        return accountName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountInfo that = (AccountInfo) o;
        return Objects.equals(systemName, that.systemName) &&
                Objects.equals(accountName, that.accountName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(systemName, accountName);
    }

    @Override
    public String toString() {
        return "account " + accountName + " on "+ systemName + "";
    }
}
