package ru.yandex.personal.mail.search.metrics.scraper.services.account;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountPropertiesLoader {
    public static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(AccountPropertiesLoader.class);

    public static AccountProperties loadProperties(Path accPath) {
        try {
            return mapper.readValue(accPath.resolve(AccountProperties.FILENAME).toFile(), AccountProperties.class);
        } catch (IOException e) {
            LOG.error("Error loading properties from " + accPath, e);
            throw new UncheckedIOException(e);
        }
    }
}
