package ru.yandex.personal.mail.search.metrics.scraper.services.archive;

import org.springframework.http.MediaType;

public class ArchiveEntry {
    private final String id;
    private final MediaType mediaType;

    public ArchiveEntry(String id, MediaType mediaType) {
        this.id = id;
        this.mediaType = mediaType;
    }

    public static ArchiveEntry image(String id) {
        return new ArchiveEntry(id, MediaType.IMAGE_PNG);
    }

    public static ArchiveEntry html(String id) {
        return new ArchiveEntry(id, MediaType.TEXT_HTML);
    }

    public static ArchiveEntry json(String id) {
        return new ArchiveEntry(id, MediaType.APPLICATION_JSON);
    }

    public String getId() {
        return id;
    }

    public MediaType getMediaType() {
        return mediaType;
    }
}
